<?php 
/**
Copyright (c) 2009, Jamie Estep (jestep.com | ecommerce-blog.org)
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY Jamie Estep ''AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Jamie Estep BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/




/**
* Create a singleton process tracker
*/
class trackPid
{
	private static $instance;
	
	private function __construct()
	{
		if($this->db = new SQLiteDatabase('sqlite/cache.db'))
		{
			if(!$q = @$this->db->query('SELECT id FROM cache LIMIT 1'))
			{
				$this->db->query("
				CREATE TABLE cache (
				id 			INTEGER default '1',
				envelope 	CHAR (16),
				pid 		INTEGER,
				status 		INTEGER default '0',
				output		TEXT,
				PRIMARY KEY (id)
				);
				");
			}
	
		} else {
			die('Cannot Access Database cache.db');
		}
		
	}
	
	public static function singleton()
	{
		if (!self::$instance)
        {
            self::$instance = new trackPid();
        }
        return self::$instance;
	}
	
	/**
	* Create a unique envelope so that this script could potentially run in parallel with another copy of it
	*/
	function createEnvelope($processes,$timeout=60)
	{
		$envelope = self::randomName();
		
		/**
		* Each PID is put into the database
		*/
		for($i = 1; $i<= $processes; $i++)
		{
			$this->db->query("INSERT INTO cache (id, envelope, pid) VALUES (NULL, '".$envelope."', '".$i."')");
		}
		
		return $envelope;
	}
	
	/**
	* Set a specific PID as complete
	*/
	function setPidComplete($envelope,$pid)
	{
		if(!$this->db->query("UPDATE cache SET status = '1' WHERE envelope = '".$envelope."' AND pid = '".$pid."'"))
		{
			
			die( 'ERROR UPDATING DATABASE' );
			
		}
	}
	
	/**
	* Set the output of a specific PID if you need to retrieve it on the main script
	*/
	function setOutput($envelope,$pid,$output)
	{
		$this->db->query("UPDATE cache SET output = '".$output."' WHERE envelope = '".$envelope."' AND pid = '".$pid."'");
	}
	
	/**
	* Return the output for a particular PID
	*/
	function returnOutput($envelope,$pid)
	{
		$query =  $this->db->query("SELECT output FROM cache WHERE envelope = '".$envelope."' AND pid = '".$pid."' LIMIT 1");
		
		return $query->fetch(SQLITE_ASSOC);
	}
	
	/**
	* Check to see if all the PIDS are finished processing, fail if any are still processing
	*/
	function returnStatus($envelope)
	{
		$query = $this->db->query("SELECT pid, status FROM cache WHERE envelope = '".$envelope."'");
		
		while ($entry = $query->fetch(SQLITE_ASSOC))
		{
			if($entry['status'] == 0)
			{
				return false;
			}
		}
		return true;
	}
	
	/**
	* Manually destroy everything
	*/
	
	function cleanup($envelope)
	{
		$this->db->query("DELETE FROM cache WHERE envelope = '".$envelope."'");
	}
	
	
	/**
	* Checks the status of our processes. Once they are successful returns SUCCESS, otherwise returns as failed.
	*/
	function checkStratus($envelope, $timeout = 10, $sleep = 100000) {
		
		$cur = 0;
		
		while( $cur < $timeout ) {
			
			// wait for 100000 microseconds, or .1 seconds by default
			usleep($sleep);
			
			//usleep is microseconds, and we need to convert it to seconds
			$cur += ($sleep/1000000);
			
			if($this->returnStatus($envelope)){
				
				return true;
			}
		}
		/**
		* If process is still running after timeout return false
		*/
		return false;
	}
	
	/**
	* Generate a random string for our envelope
	*/
	static function randomName()
	{
		$string = '';
		$possible = "0123456789bcdfghjkmnpqrstvwxyzABTOIIUYBHXSB";
		
		for($i=1;$i<16;$i++):
			$char = substr($possible, mt_rand(0, strlen($possible)-1), 1);
				$string .= $char;
		endfor;
		
		return $string;
	}
}