<?php
//Start time for script benchmarking
$time_start = microtime(true);

//Get out singleton class
require ('lib/singleton.class.php');

/**
* Enter the names of the processes you want to execute
* Entering a process moore than once to create multiple copies of it
* All of these processes will process asyncronously
* Make sure that they are not dependant on eachother
*/
$processes_to_execute = array(
'other_process.php',
'other_process.php'
);

//Set the number of processes you want to allow
$number_of_processes = count($processes_to_execute);

//Set the time limit in seconds you want this script to execute for
$time_limit = 30;

//Instantiate our process tracking singleton
$pid = trackPid::singleton();

//Create the envelope for this set of processes
$envelope = $pid->createEnvelope($number_of_processes);

//Loop through and create the number of processes we want
for($i=1;$i<=$number_of_processes;$i++):

	$file = $processes_to_execute[$i-1];
	
	/**
	* You can add additional variables here. Add them in the form of variable=value without ? or &
	* These will be accessable as GET variables
	*/
	$query_string = ' envelope=' . $envelope . ' pid=' . $i . ' time_limit=' . $time_limit;
		
		
	exec("nohup /usr/local/bin/php -f " . $file . $query_string . " > /dev/null &");
		
	//for debugging
	//exec("nohup /usr/local/bin/php -f " . $file . $query_string . "  &", $output);
	//globalFormat::debug($output);

endfor;

// Reset the time limit after we spawn our background processes, add 1 second so that the other processes timeout first
ini_set("max_execution_time",$time_limit+1);


/**
* The checkstatus method will keep this script going 
* The default timout is 60 seconds
* Once all of the processes are complete, the script will stop immediately
*/
if($pid->checkStratus($envelope,$time_limit+5)):

	echo 'our processes worked';
	
	//If you get the output from your child processes, you can access it via
	// get output via: $output = $pid->returnOutput($envelope,$process_number);

else:

	echo 'our processes failed';

endif;

//Destroy the database entries since we don't need them anymore
$pid->cleanup($envelope);

//Stop time for script benchmarking
$time_end = microtime(true);

//Execution time
$time = $time_end - $time_start;

echo "Script took $time seconds\n";

?>
